import type { NextApiRequest, NextApiResponse } from "next";
import { prisma } from "@/lib/prisma";
import { requireAdmin } from "@/lib/admin";
import { derivePseudoAddress } from "@/lib/pseudoAddress";

export default async function handler(
  req: NextApiRequest,
  res: NextApiResponse
) {
  const session = await requireAdmin(req, res);
  if (!session) return;

  if (req.method !== "POST")
    return res.status(405).json({ ok: false, error: "Method not allowed" });

  const users = await prisma.user.findMany({
    where: { ethAddress: null },
    select: { id: true, email: true },
  });

  for (const u of users) {
    const addr = derivePseudoAddress(u.id);
    await prisma.user.update({
      where: { id: u.id },
      data: { ethAddress: addr },
    });
  }

  res.status(200).json({ ok: true, updated: users.length });
}
